property primary-visible base.primary.visible
property primary-y base.primary.y
property recommends-visible base.recommends.visible

ClipLayer
{
	id: 'base'
	anchors: 'fill'
	visible: true

	Rectangle
	{
		id: 'background'
		anchors: 'fill'
		color: '#aa000000'
	}

	// This needs another clip because an action button can bounce up from the
	// bottom, and we don't want that to just appear in the middle of the primary
	// asset.
	Clip
	{
		id: 'secondary'
		x: 0
		y: 553
		height: 530
		width: 600

		Asset
		{
			id: 'asset'
			anchors: 'fill'
		}
	}

	Layer
	{
		id: 'primary'
		visible: false
		x: 0
		// The original positioning at y:0 and height: 320 caused a gap to briefly appear during the
		// bounce in animation. The new positioning makes the image tall enough that the gap never
		// appears, but also means that the bottom 35 pixels of the image will be cut off by the Tray
		// once it has settled into place.
		//y: 0
		//height: 320
		y: 125
		height: 355
		width: 600

		Asset
		{
			id: 'asset'
			anchors: 'fill'
		}
	}

	// This is just a layer so we can make sure it appears on top of the image
	Layer
	{
		id: 'recommends'
		anchors: 'horizontal-center'
		y: 498
		height: 35
		width: 226

		Image
		{
			id: 'image'
			anchors: 'fill'
			image-src: 'sonic_recommends.png'
		}
	}
}