// PROPERTIES
property red-button-visible customer-base.red-button-base.visible
property customer-visible customer-base.visible

//main area
property customer-main-area-text customer-base.mainArea_item.messageText.text
property customer-main-area-bg-visible customer-base.mainArea.visible
property customer-main-area-item-visible customer-base.mainArea_item.visible
property customer-main-area-padding-left customer-base.mainArea_item.padding-left
property customer-main-area-message-visible customer-base.mainArea_item.messageText.visible
property customer-main-area-timeline-visible customer-base.mainArea_item.timeline.visible

//opacity layers
property customer-main-area-opacity-visible customer-base.mainArea_item.mainArea_opacity_layer.visible
property customer-opacity-visible customer-base.base_opacity_layer.visible

//stall id area
property customer-stall-number-area-visible customer-base.stallNumberArea.visible
property customer-stall-number-area-text customer-base.stallNumberArea.stallNumberText.text
property customer-stall-number-area-number customer-base.stallNumberArea.stallNumber.text

//top accent line
property customer-accent-line-bg-visible customer-base.topAccentLine.visible
property customer-accent-line-color customer-base.topAccentLine.color

//red button bar
property red-button-text customer-base.red-button-base.red-button-text-layer.red-button-text.text

//order tray
property customer-totals-visible customer-base.OrderConfirmationTotals.visible
property customer-totals-tax customer-base.OrderConfirmationTotals.Tax.text
property customer-totals-total customer-base.OrderConfirmationTotals.Total.text
property customer-spanish-visible customer-base.SpanishButtonBackground.visible
property customer-spanish-text customer-base.SpanishButtonBackground.SpanishButton.text
property customer-scrollup-visible customer-base.ReceiptUpArrow.visible
property customer-scrolldown-visible customer-base.ReceiptDownArrow.visible
property customer-scrollup-disabled customer-base.ReceiptUpArrow.disabled
property customer-scrolldown-disabled customer-base.ReceiptDownArrow.disabled

//timeline
property timeline-padding-left customer-base.mainArea_item.timeline.padding-left
property timeline-order-text customer-base.mainArea_item.timeline.order-label.text
property timeline-pay-text customer-base.mainArea_item.timeline.pay-label.text
property timeline-cooking-text customer-base.mainArea_item.timeline.cooking-label.text
property timeline-deliver-text customer-base.mainArea_item.timeline.deliver-label.text
property timeline-order-opacity customer-base.mainArea_item.timeline.order.opacity
property timeline-pay-opacity customer-base.mainArea_item.timeline.pay.opacity
property timeline-cooking-opacity customer-base.mainArea_item.timeline.cooking.opacity
property timeline-deliver-opacity customer-base.mainArea_item.timeline.deliver.opacity
property timeline-pay-image-visible customer-base.mainArea_item.timeline.pay.image.visible
property timeline-pay-button-disabled customer-base.mainArea_item.timeline.pay.PayButton.disabled
property timeline-deliver-image-visible customer-base.mainArea_item.timeline.deliver.image.visible
property timeline-bar-order-pay-opacity customer-base.mainArea_item.timeline.bar-order-pay.opacity
property timeline-bar-pay-cooking customer-base.mainArea_item.timeline.bar-pay-cooking.opacity
property timeline-bar-cooking-deliver-opacity customer-base.mainArea_item.timeline.bar-cooking-deliver.opacity

property timeline-cooking-loading-visible customer-base.mainArea_item.timeline.cooking.image-loading.visible
property timeline-deliver-loading-visible customer-base.mainArea_item.timeline.deliver.image-loading.visible

//customer info
property customer-info-area-visible customer-base.customerInfoArea.visible
property customer-info-area-text customer-base.customerInfoArea.customerText.text
property customer-info-padding-bottom customer-base.customerInfoArea.padding-bottom
property customer-image-padding-top customer-base.customerInfoArea.customerImage.padding-top
property customer-image-source customer-base.customerInfoArea.customerImage.image-src
property customer-image-visible customer-base.customerInfoArea.customerImage.visible
property customer-default-image-visible customer-base.customerInfoArea.defaultCustomerImage.visible



// TRAY
Item
{
	id: 'customer-base'
	anchors: 'fill'
	visible: false
	
	Rectangle
	{
		id: 'topAccentLine'
		anchors: 'left|top|right'
		height: 5
		color: '#EED713'
	}
	
    // BLACK BACKGROUND
	Rectangle
	{
		id: 'mainArea'
		anchors: 'fill'
		padding-top: 5
		color: 'black'
	}
	
	Item 
	{
		id: 'mainArea_item'
		anchors: 'fill'
		padding-top: 5
		padding-left: 150
		
		Text
		{
			id: 'messageText'
			anchors: 'fill'
            padding-bottom: 20

			font-name: 'SONIC Sans Round'
			font-weight: 'regular'
			font-size: 20
			color: 'black'

			vertical-alignment: center
			
			text: ''
		}

        // TIMELINE
		Item
		{
			id: 'timeline'
			anchors: 'top|bottom|left'
            padding-left: 130
			width: 1160

			Layer
			{
				id: 'order'
				anchors: 'top|bottom|horizontal-center'
				width: 100
                padding-right: 580
                visible: true
				Image
				{
					id: 'image-bg'
					image-src: 'timeline-icon_blank-small.png'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true
				}

				Layer
				{
					id: 'image'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
                    padding-top: 22
					visible: true

					Image
					{
						image-src: 'timeline-icon_order-small.png'
						anchors: 'fill'
						visible: true
					}
				}
			}
            Text
			{
				id: 'order-label'
				text: 'Order'
				anchors: 'top|bottom|horizontal-center'
				height: 30
                width: 200
				padding-top: 62
                padding-right: 580
				visible: true
			}

			Layer
			{
				id: 'pay'
				anchors: 'top|bottom|horizontal-center'
				width: 100
				height: 10
				padding-right: 193
				visible: true

				Image
				{
					id: 'image-bg'
					image-src: 'timeline-icon_pay-unpaid-small.png'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true
				}

				Layer
				{
					id: 'image'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true

					Image
					{
						image-src: 'timeline-icon_pay-small.png'
						anchors: 'fill'
						visible: true
					}
				}
                Button
                {
                    id: 'PayButton'
                    observation-screen-name: 'Tray_Timeline_PayButton'
                    control-id: 'Tray'

                    anchors: 'fill'
                    visible: true
                    disabled: false

                    text: ''
                }
			}

            Text
			{
				id: 'pay-label'
				text: 'Pay'
				anchors: 'top|bottom|horizontal-center'
				height: 30
                width: 200
				padding-top: 62
                padding-right: 193
				visible: true
			}

			Layer
			{
				id: 'cooking'
				anchors: 'top|bottom|horizontal-center'
				width: 100
				padding-left: 193
				visible: true

				Image
				{
					id: 'image-bg'
					image-src: 'timeline-icon_blank-small.png'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true
				}
				
				Layer
				{
					id: 'image'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true

					Image
					{
						image-src: 'timeline-icon_kitchen-drink-small.png'
						anchors: 'fill'
						visible: true
					}
				}

                Layer
                {
                    id: 'image-loading'
                    anchors: 'horizontal-center|vertical-center'
                    height: 79
                    width: 79
                    padding-top: 22
                    visible: false

                    Image
					{
						image-src: 'loading-circle.png'
						anchors: 'fill'
						visible: true
					}
                }
			}
            Text
			{
				id: 'cooking-label'
				text: 'In the kitchen'
				anchors: 'top|bottom|horizontal-center'
				height: 30
                width: 200
				padding-top: 62
                padding-left: 193
				visible: true
			}
			
			Layer
			{
				id: 'deliver'
				anchors: 'top|bottom|horizontal-center'
				width: 100
                padding-left: 580
                visible: true

				Image
				{
					id: 'image-bg'
					image-src: 'timeline-icon_blank-small.png'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true
				}

				Layer
				{
					id: 'image'
					anchors: 'horizontal-center|vertical-center'
					height: 62
					width: 62
					padding-top: 22
					visible: true

					Image
					{
						image-src: 'timeline-icon_onitsway-small.png'
						anchors: 'fill'
						visible: true
					}
				}

                Layer
                {
                    id: 'image-loading'
                    anchors: 'horizontal-center|vertical-center'
                    height: 79
                    width: 79
                    padding-top: 22
                    visible: false

                    Image
					{
						image-src: 'loading-circle.png'
						anchors: 'fill'
						visible: true
					}
                }
			}
            Text
			{
				id: 'deliver-label'
				text: 'On its way!'
				anchors: 'top|bottom|horizontal-center'
                height: 30
				width: 200
                padding-left: 580
				padding-top: 62
                visible: true
			}

			Layer
			{
				id: 'bar-order-pay'
				anchors: 'horizontal-center|vertical-center'
				width: 326
				height: 5
				padding-right: 387
				padding-top: 22

				Rectangle
				{
					anchors: 'fill'
					color: 'white'
					visible: true
				}
			}

			Layer
			{
				id: 'bar-pay-cooking'
				anchors: 'horizontal-center|vertical-center'
				width: 326
				height: 5
				padding-right: 0
				padding-top: 22
				visible: true

				Rectangle
				{
					anchors: 'fill'
					color: 'white'
					visible: true
				}
			}

			Layer
			{
				id: 'bar-cooking-deliver'
				anchors: 'horizontal-center|vertical-center'
				width: 326
				height: 5
				padding-left: 386
				padding-top: 22
				visible: true

				Rectangle
				{
					anchors: 'fill'
					color: 'white'
					visible: true
				}
			}
		}

        // Black area used for fade-in during visit complete goodbye message
        Layer
        {
            id: 'mainArea_opacity_layer'
            anchors: 'fill'
            visible: false

            Rectangle
            {
                anchors: 'fill'
                color: 'black'
                visible: true
            }
        }
	}
    
    // RED BUTTON TRAY
    Layer
    {
	    id: 'red-button-base'
	    anchors: 'fill'
	    visible: false

	    Rectangle
	    {
		    id: 'red-button-background'
		    anchors: 'fill'
            padding-top: 5
		    visible: true
		    color: '#ef242b'
	    }
        
        Layer
        {
            id: 'red-button-text-layer'
            anchors: 'fill'
            visible: true

            Text
            {
                id: 'red-button-text'
                anchors: 'fill'
                padding-bottom: 20
                padding-left: 300
                visible: true
                color: white

                text: 'Red button activated. We will be with you soon.'
		        font-name: 'SONIC Sans Round Semi'
		        font-size: 54

                horizontal-alignment: center
                vertical-alignment: center
            }
        }
    }
	
    // STALL INFO
	Layer
	{
		id: 'stallNumberArea'
		anchors: 'top|left|bottom'
		padding-top: 5
		width: 160
        visible: true
		
		Text
		{
			id: 'stallNumberText'
			anchors: 'fill'
			padding-bottom: 90
            padding-left: 21

			font-name: 'SONIC Sans Round'
			font-weight: 'regular'
			font-size: 30
			color: 'white'

			horizontal-alignment: 'center'
            vertical-alignment: 'center'
			
			text: ''
		}

        
        Text
		{
			id: 'stallNumber'
			anchors: 'fill'
			padding-top: 35
            padding-left: 21

			font-name: 'SONIC Sans Round'
			font-weight: 'regular'
			font-size: 30
			color: 'white'

			horizontal-alignment: 'center'
            vertical-alignment: 'center'
			
			text: ''
		}
	}

    // CUSTOMER INFO
	Layer
	{
		id: 'customerInfoArea'
		anchors: 'top|left|bottom'
        visible: true
		padding-top: 5
		width: 480
		
		Text
		{
			id: 'customerText'
			anchors: 'top|left|bottom'
            padding-left: 142

			font-name: 'SONIC Sans Round'
			font-weight: 'regular'
			font-size: 40
			color: 'white'

            width: 258

			horizontal-alignment: 'left'
			vertical-alignment: 'center'
			line-vertical-alignment: 'center'
			
			text: ''
		}

        Image
        {
            id: 'defaultCustomerImage'
            image-src: 'empty_profile.png'
            anchors: 'top|left'
            visible: true

            padding-top: 26
            padding-left: 13
            padding-bottom: 21

            width: 108
            height: 108
        }

        Image
        {
            id: 'customerImage'
            image-src: ''
            image-mask: 'profile_mask.png'
            anchors: 'top|left'
            visible: false

            padding-top: 26
            padding-left: 13
            padding-bottom: 21

            width: 108
            height: 108

            Image
            {
                id: 'outline'
                image-src: 'profile_outline.png'
                anchors: 'fill'
                visible: true
            }
        }

        ObservationMouseArea
        {
            id: 'LogoutButton'
            observation-screen-name: 'Tray_LogoutButton'
            control-id: 'Tray'

            anchors: 'fill'

            visible: true
            disabled: false

            text: ''
        }
	}

    // Black area used for fade-out during visit complete goodbye message
    Layer
    {
        id: 'base_opacity_layer'
        anchors: 'fill'
        visible: false
        padding-top: 5

        Rectangle
        {
            anchors: 'fill'
            color: 'black'
            visible: true
        }
    }
	

    // ORDERING SCREEN FIELDS

    Rectangle
    {
        id: 'SpanishButtonBackground'
        anchors: 'vertical-center|left'
		width: 145
		height: 50
		padding-left: 400
		padding-bottom: 5

        font-name: 'SONIC Sans Round'
		font-size: 24
		font-weight: 'bold'

        color: black
        border-thickness: 2
        border-color: '#B1B5BA'
        rounded-corners: all
		x-radius: 3
		y-radius: 3

		visible: false

        Button
	    {
		    id: 'SpanishButton'
		    observation-screen-name: 'Tray_LanguageButton'
		    control-id: 'Tray'
	
		    text: 'ESPANOL' // This needs to be a UTF8 string, but our parser won't allow it, so no tilde
		    anchors: 'fill'

		    font-name: 'SONIC Sans Round'
		    font-size: 24
		    font-weight: 'bold'

		    visible: true

		    disabled: false
		    disabled-text-color: '#61656A'
		    pressed-text-color: '#9195A9'
		    text-color: '#B1B5BA'
		    //image-idle: 'language_button_customer_checkin.png'
		    //image-pressed: 'language_button_pressed_customer_checkin.png'
		    //image-disabled: 'language_button_customer_checkin.png'
	
		    text-idle-padding-bottom: 5
		    text-pressed-padding-top: 0
		    text-disabled-padding-bottom: 13
	    }
    }

	Button
	{
		id: 'ReceiptUpArrow'
		observation-screen-name: 'Tray_ReceiptUpArrowButton'
		control-id: 'Tray'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 190
		height: 103
		padding-left: 788
		padding-bottom: 5

		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'oc_arrow_up_idle_customer_checkin.png'
		image-pressed: 'oc_arrow_up_pressed_customer_checkin.png'
		image-disabled: 'oc_arrow_up_pressed_customer_checkin.png'
	}

	Button
	{
		id: 'ReceiptDownArrow'
		observation-screen-name: 'Tray_ReceiptDownArrowButton'
		control-id: 'Tray'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 190
		height: 103
		padding-left: 1009
        padding-bottom: 5

		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'oc_arrow_down_idle_customer_checkin.png'
		image-pressed: 'oc_arrow_down_pressed_customer_checkin.png'
		image-disabled: 'oc_arrow_down_pressed_customer_checkin.png'
	}

	Item
	{
		id: 'OrderConfirmationTotals'
		anchors: 'fill'
		double-buffer: yes
		visible: false

		Text
		{
			id: 'Tax'
			text: 'TAX $0.00'

			font-name: 'SONIC Sans Round'
			font-weight: 'bold'
			font-size: 27

			height: 30
			width: 400

			color: white

			anchors: 'bottom|right'

			padding-bottom: 100
			padding-right: 50

			horizontal-alignment: far
		}

		Text
		{
			id: 'Total'
			text: 'TOTAL $0.00'

			font-name: 'SONIC Sans Round'
			font-weight: 'bold'
			font-size: 72

			height: 82
			width: 500 

			color: white

			anchors: 'bottom|right'

			padding-bottom: 15
			padding-right: 50

			horizontal-alignment: far
		}
	}
}
