property banner-text base.top_banner.text.text
property banner-text-visible base.top_banner.text.visible
property side-image base.main_box.side_image.image-src
property back-to-tip-selection-button base.back_to_tip_selection.back
property back-to-tip-selection-button-text base.back_to_tip_selection.back.text
property back-to-tip-selection-visible base.back_to_tip_selection.back.visible
property tip-selection-confirm-button base.main_box.full_content.confirm
property tip-selection-confirm-button-text base.main_box.full_content.confirm.text

property confirm_title base.main_box.full_content.results_partial.confirm_title.text
property order_label base.main_box.full_content.results_partial.grid.top_left.text
property tip_label base.main_box.full_content.results_partial.grid.middle_left.text
property total_label base.main_box.full_content.results_partial.grid.bottom_left.text

property order_amount base.main_box.full_content.results_partial.grid.top_right.text
property tip_amount base.main_box.full_content.results_partial.grid.middle_right.text
property total_amount base.main_box.full_content.results_partial.grid.bottom_right.text

// Partial content screen with back button
property back-button-visible base.main_box.back.visible
property partial-content-visible base.main_box.partial_content.visible
property partial-card-visible base.main_box.partial_content.card.visible
property card-message base.main_box.partial_content.card.message.text



Layer
{
	id: 'base'
	anchors: 'fill'

	Image
	{
		id: 'background'
		anchors: 'fill'
		image-src: 'blue_background.png'
	}

	Layer
	{
		id: 'top_banner'
		height: 280
		width: 1800
		x: 60
		y: 820


		Text
		{
			id: 'text'
			height: 130
			width: 1800
			anchors: 'horizontal-center|bottom'
		}
	}

	// Background to the main box
	Image
	{
		height: 540
		width: 1240
		x: 336
		y: 200
		image-src: 'payment_mode_box_background.png'
	}

	// Main box, excluding the blue border and drop shadow
	Item
	{
		id: 'main_box'

		height: 501
		width: 1209
		x: 354
		y: 220

        Image
		{
			id: 'side_image'
			x: 0
			y: 0
			width: 345
			height: 501
		}

		Item
		{
			id: 'partial_content'
			width: 760
			height: 501
			x: 325
			y: 0

			Item
			{
				id: 'card'
				anchors: 'fill'

				Text
				{
					id: 'message'
					text: ''
					anchors: 'fill'
				}
			}
		}

		Layer
		{
			id: 'full_content'
			width: 900
			height: 501
			x: 345
			y: 0

			Item
			{
				id: 'processing'
				anchors: 'fill'

				Image
				{
					id: 'dots'
					width: 107
					height: 10
					anchors: 'vertical-center|horizontal-center'
					padding-top: 50 // why isn't this padding-bottom?
					image-src: ''
				}

				Text
				{
					id: 'message'
					text: ''
					anchors: 'left|right|vertical-center'
					height: 60
					padding-bottom: 50 // why isn't this padding-top?
				}
			}

			Item
			{
				id: 'results_partial'
				anchors: 'top|left|right'
				height: 501

				Text
				{
					id: 'confirm_title'
					anchors: 'left|right|vertical-center'
					height: 168
					padding-top: 140
					text: ''
				}

				Image
				{
					id: 'grid'
					anchors: 'vertical-center|horizontal-center'
					width: 470
					height: 232
					padding-bottom: 20
					image-src: 'tip_confirmation_table_background.png'

					Text
					{
						id: 'top_left'
						anchors: 'top|left'
						width: 235
						height: 103
						text: ''
					}

					Text
					{
						id: 'top_right'
						anchors: 'top|right'
						width: 235
						height: 103
						text: ''
					}

					Text
					{
						id: 'middle_left'
						anchors: 'vertical-center|left'
						width: 235
						height: 103
						text: ''
					}

					Text
					{
						id: 'middle_right'
						anchors: 'vertical-center|right'
						width: 235
						height: 103
						text: ''
					}

					Text
					{
						id: 'bottom_left'
						anchors: 'bottom|left'
						width: 235
						height: 103
						text: ''
					}

					Text
					{
						id: 'bottom_right'
						anchors: 'bottom|right'
						width: 235
						height: 103
						text: ''
					}
				}
			}
			Button
			{
				id: 'confirm'
				height: 100
				width: 378
				text: ''
				observation-screen-name: 'TipConfirmation_Yes'
				control-id: 'TipConfirmation'
				image-idle: 'ActionButton.png'
				image-pressed: 'ActionButton_Pressed.png'
				anchors: 'bottom|horizontal-center'
			}
		}
	}

	Layer
	{
		id: 'back_to_tip_selection'
		width: 600
		height: 100
		x: 745
		y: 100

		Button
		{
			id: 'back'
			height: 100
			width: 600
			text: ''
			observation-screen-name: 'TipConfirmation_Yes'
			control-id: 'TipConfirmation'
			image-idle: 'ActionButton.png'
			image-pressed: 'ActionButton_Pressed.png'
			anchors: 'bottom|horizontal-center'
		}
	}
}
