property banner-text base.top_banner.text.text
property side-image base.main_box.side_image.image-src
property bottom-mobile-code-visible base.bottom_mobile_code.visible
property bottom-mobile-code-message base.bottom_mobile_code.message.text

// Partial content screen with back button
property back-button-visible base.main_box.back.visible
property partial-content-visible base.main_box.partial_content.visible
property partial-cash-visible base.main_box.partial_content.cash.visible
property partial-card-visible base.main_box.partial_content.card.visible
property partial-app-visible base.main_box.partial_content.app.visible
property partial-app-disabled-visible base.main_box.partial_content.app_disabled.visible
property partial-app-paired-visible base.main_box.partial_content.app_paired.visible
property cash-message base.main_box.partial_content.cash.message.text
property card-message base.main_box.partial_content.card.message.text
property app-message base.main_box.partial_content.app.message.text
property app-disabled-message base.main_box.partial_content.app_disabled.message.text
property app-paired-message base.main_box.partial_content.app_paired.message.text
property mobile-code-1 base.main_box.partial_content.app.mobile_code.1.text.text
property mobile-code-2 base.main_box.partial_content.app.mobile_code.2.text.text
property mobile-code-3 base.main_box.partial_content.app.mobile_code.3.text.text
property mobile-code-4 base.main_box.partial_content.app.mobile_code.4.text.text
property mobile-code-5 base.main_box.partial_content.app.mobile_code.5.text.text
property mobile-code-6 base.main_box.partial_content.app.mobile_code.6.text.text

// Full content screen without back button
property full-content-visible base.main_box.full_content.visible
property processing-visible base.main_box.full_content.processing.visible
property processing-message base.main_box.full_content.processing.message.text
property processing-dots-image base.main_box.full_content.processing.dots.image-src
property approved-results-visible base.main_box.full_content.results_approved.visible
property approved-results-message base.main_box.full_content.results_approved.message.text
property approved-results-height base.main_box.full_content.results_approved.height
property partial-results-visible base.main_box.full_content.results_partial.visible
property partial-results-message base.main_box.full_content.results_partial.message.text
property partial-results-height base.main_box.full_content.results_partial.height
property error-results-visible base.main_box.full_content.results_error.visible
property error-results-message base.main_box.full_content.results_error.message.text
property error-results-height base.main_box.full_content.results_error.height
property balance-visible base.main_box.full_content.balance.visible
property balance-text base.main_box.full_content.balance.text.text
property results-grid-top-left base.main_box.full_content.results_partial.grid.top_left.text
property results-grid-top-right base.main_box.full_content.results_partial.grid.top_right.text
property results-grid-bottom-left base.main_box.full_content.results_partial.grid.bottom_left.text
property results-grid-bottom-right base.main_box.full_content.results_partial.grid.bottom_right.text

Layer
{
	id: 'base'
	anchors: 'fill'

	Image
	{
		id: 'background'
		anchors: 'fill'
		image-src: 'blue_background.png'
	}

	Layer
	{
		id: 'top_banner'
		height: 280
		width: 1800
		x: 60
		y: 820


		Text
		{
			id: 'text'
			height: 130
			width: 1800
			anchors: 'horizontal-center|bottom'
		}
	}

	Layer
	{
		id: 'bottom_mobile_code'
		height: 118
		width: 1043
		x: 438
		y: 0

		Image
		{
			id: 'background'
			anchors: 'fill'
			image-src: 'payment_mode_code_background.png'
		}

		Text
		{
			id: 'message'
			anchors: 'fill'
			text: ''
		}
	}

	// Background to the main box
	Image
	{
		height: 540
		width: 1240
		x: 336
		y: 200
		image-src: 'payment_mode_box_background.png'
	}

	// Main box, excluding the blue border and drop shadow
	Item
	{
		id: 'main_box'
		height: 501
		width: 1209
		x: 354
		y: 220

        Image
		{
			// Switched out between cash, card, and app
			id: 'side_image'
			x: 0
			y: 0
			width: 345
			height: 501
		}

		Item
		{
			id: 'partial_content'
			width: 760
			height: 501
			x: 325
			y: 0

			Item
			{
				id: 'cash'
				anchors: 'fill'

				Text
				{
					id: 'message'
					text: ''
					anchors: 'fill'
				}
			}

			Item
			{
				id: 'card'
				anchors: 'fill'

				Text
				{
					id: 'message'
					text: ''
					anchors: 'fill'
				}
			}

			Item
			{
				id: 'app'
				anchors: 'fill'

				Text
				{
					id: 'message'
					text: ''
					anchors: 'fill'
				}

				// The code will appear on top of the text -- the text should
				// leave a gap of sufficient size for the code.
				Item
				{
					id: 'mobile_code'
					anchors: 'vertical-center|horizontal-center'
					width: 540
					// The height only needs to be slightly greater than 100 for the
					// current text size, but there's no harm making it bigger for
					// more flexibility from the marketing copy.
					height: 200

					Layer
					{
						id: '1'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 0

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}

					Layer
					{
						id: '2'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 92

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}

					Layer
					{
						id: '3'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 184

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}

					Layer
					{
						id: '4'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 276

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}

					Layer
					{
						id: '5'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 368

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}

					Layer
					{
						id: '6'
						anchors: 'left|top|bottom'
						width: 80
						padding-left: 450

						Text
						{
							id: 'text'
							anchors: 'fill'
							text: ''
						}
					}
				}
			}

			Item
			{
				id: 'app_disabled'
				anchors: 'fill'

				Text
				{
					id: 'message'
					text: ''
					anchors: 'fill'
				}
			}

			Item
			{
				id: 'app_paired'
				anchors: 'fill'

				Image
				{
					id: 'image'
					image-src: 'Phone.png'
					height: 407
					width: 415
					anchors: 'top|horizontal-center'
				}

				Text
				{
					id: 'message'
					text: ''
					anchors: 'bottom|left|right'
					height: 130
				}
			}
		}

		ClipLayer
		{
			id: 'full_content'
			width: 900
			height: 501
			x: 345
			y: 0

			Item
			{
				id: 'processing'
				anchors: 'fill'

				Image
				{
					id: 'dots'
					width: 107
					height: 10
					anchors: 'vertical-center|horizontal-center'
					padding-top: 50 // why isn't this padding-bottom?
					image-src: ''
				}

				Text
				{
					id: 'message'
					text: ''
					anchors: 'left|right|vertical-center'
					height: 60
					padding-bottom: 50 // why isn't this padding-top?
				}
			}

			Item
			{
				id: 'results_approved'
				anchors: 'top|left|right'
				height: 501

				Layer
				{
					id: 'check'
					width: 100
					height: 100
					anchors: 'vertical-center|horizontal-center'
					padding-top: 100

					Image
					{
						id: 'check_img'
						anchors: 'fill'
						image-src: 'greencheck-thick-small.png'
					}
				}

				Text
				{
					id: 'message'
					anchors: 'fill'
                    vertical-alignment: 'Center'
					padding-top: 100
				}
			}

			Item
			{
				id: 'results_partial'
				anchors: 'top|left|right'
				height: 501

				Text
				{
					id: 'message'
					anchors: 'left|right|vertical-center'
					height: 168
					padding-top: 140
					text: ''
				}

				Image
				{
					id: 'grid'
					anchors: 'vertical-center|horizontal-center'
					width: 626
					height: 206
					padding-bottom: 20
					image-src: 'payment_table_background.png'

					Text
					{
						id: 'top_left'
						anchors: 'top|left'
						width: 313
						height: 103
						text: ''
					}

					Text
					{
						id: 'top_right'
						anchors: 'top|right'
						width: 313
						height: 103
						text: ''
					}

					Text
					{
						id: 'bottom_left'
						anchors: 'bottom|left'
						width: 313
						height: 103
						text: ''
					}

					Text
					{
						id: 'bottom_right'
						anchors: 'bottom|right'
						width: 313
						height: 103
						text: ''
					}
				}
			}

			Item
			{
				// Only used for errors without any partial payment at all.
				// If there was a partial payment, then show that one but
				// replace the message.
				id: 'results_error'
				anchors: 'top|left|right'
				height: 501

				Text
				{
					id: 'message'
					anchors: 'fill'
				}
			}

			Layer
			{
				id: 'balance'
				height: 126
				width: 860
				x: 0
				y: 0

				Image
				{
					id: 'background'
					anchors: 'fill'
					image-src: 'payment_balance_background.png'
				}
                
				Text
				{
					id: 'text'
					text: ''
					anchors: 'fill'
					horizontal-alignment: 'center'
					vertical-alignment: 'center'
				}
			}
		}

		Button
		{
			id: 'back'
			observation-screen-name: 'PaymentMode_Back'
			control-id: 'Payment'
			anchors: 'right|top|bottom'
			width: 140
			text: ''
			image-idle: 'payment_mode_back.png'
			image-pressed: 'payment_mode_back_pressed.png'
		}
	}
}