property logout-text Base.LogoutArea.LogoutText.text
property logout-cancel-padding-bottom Base.CancelArea.padding-bottom
property logout-area-padding-bottom Base.LogoutArea.padding-bottom



// Base layer for element
Layer
{
	id: 'Base'
	anchors: 'bottom|left'
	visible: true
    height: 160
    width: 530

    // Layer background
	Rectangle
	{
		id: 'Background'
		anchors: 'top|left|bottom'
		visible: true
		color: '#ef242b'
        width: 480
	}

    // Right-side drop shadow
	Image
	{
		id: 'Shadow'
        image-src: 'logout_shadow.png'
		anchors: 'top|right|bottom'
		visible: true
        width: 50
	}
    
    // Cancel button area
    Item
    {
        id: 'CancelArea'
        anchors: 'left|vertical-center'
        visible: true

        vertical-alignment: 'center'
        padding-left: 60
        width: 60
        height: 60


        // Cancel button
        ObservationMouseArea
        {
            id: 'CancelButton'
            anchors: 'fill'
            visible: true
            disabled: false

            horizontal-alignment: 'center'
			vertical-alignment: 'center'

            observation-screen-name: 'LogoutConfirmation_Cancel'
            control-id: 'LogoutConfirmation'
        }
        Image
        {
            id: 'CancelImage'
            image-src: 'x.png'
            anchors: 'fill'

            visible: true
        }
    }


    // Logout button area
    Item
    {
        id: 'LogoutArea'
        anchors: 'left|vertical-center'
        visible: true

        padding-left: 180
        width: 280
        height: 100


        // Logout background retangle
        Rectangle
        {
            id: 'LogoutBackground'
            anchors: 'fill'
            visible: true
		    rounded-corners: all
		    x-radius: 15
		    y-radius: 15

            horizontal-alignment: 'center'
			vertical-alignment: 'center'

            color: 'white'
        }

        // Logout button
        ObservationMouseArea
        {
            id: 'LogoutButton'
            anchors: 'fill'
            visible: true
            disabled: false

            horizontal-alignment: 'center'
            vertical-alignment: 'center'

            observation-screen-name: 'LogoutConfirmation_Logout'
            control-id: 'LogoutConfirmation'

            text: ''
        }

        // Logout button text
        Text
        {
            id: 'LogoutText'
            anchors: 'fill'
            visible: true
            padding-bottom: 20

            horizontal-alignment: 'center'
            vertical-alignment: 'center'

            font-name: 'SONIC Sans Round Bold'
            font-weight: 'bold'
            font-size: 20
            color: 'black'
            text: 'Log out'
        }
    }
}
