
property notification-visible base.NotificationArea.visible
property notification-empty-visible base.NotificationArea.notification_Empty.visible
property notification-preorder-visible base.NotificationArea.notification_Preorder.visible
property notification-post-order-eat-visible base.NotificationArea.notification_PostOrder_Eat.visible
property totals-visible base.OrderConfirmationTotals.visible
property totals-subtotal base.OrderConfirmationTotals.Subtotal.text
property totals-tax base.OrderConfirmationTotals.Tax.text
property totals-total base.OrderConfirmationTotals.Total.text
property pay-visible base.PayButton.visible
property startover-visible base.StartOverButton.visible
property spanish-visible base.SpanishButton.visible
property spanish-text base.SpanishButton.text
property scrollup-visible base.ReceiptUpArrow.visible
property scrolldown-visible base.ReceiptDownArrow.visible

Layer
{
	id: 'base'
	anchors: 'fill'

	Rectangle
	{
		id: 'background'
		anchors: 'fill'
		color: '#2D75B5'
	}

	Rectangle
	{
		id: 'NotificationArea'
		anchors: 'fill'
		color: 'transparent'
		visible: false
		
		Image
		{
			id: 'notification_Empty'
			anchors: 'vertical-center|horizontal-center'
			width: 673
			height: 25
			image-src: 'Taskbar_NotificationText_Empty.png'
			visible: false
		}
		
		Image
		{
			id: 'notification_Preorder'
			anchors: 'vertical-center|horizontal-center'
			width: 432
			height: 25
			image-src: 'Taskbar_NotificationText_Preorder.png'
			visible: false
		}
		
		Image
		{
			id: 'notification_PostOrder_Eat'
			anchors: 'vertical-center|horizontal-center'
			width: 429
			height: 25
			image-src: 'Taskbar_NotificationText_PostOrder_Eat.png'
			visible: false
		}
	}
	
	Button
	{
		id: 'SpanishButton'
		observation-screen-name: 'Taskbar_LanguageButton'
		control-id: 'Taskbar'
	
		text: 'ESPANOL' // This needs to be a UTF8 string, but our parser won't allow it, so no tilde
		anchors: 'vertical-center|left'
		width: 225
		height: 92
		padding-left: 250

		font-name: 'Open Sans'
		font-size: 25
		font-weight: 'extrabold'

		visible: false

		disabled: false
		disabled-text-color: black
		pressed-text-color: white
		text-color: white
		image-idle: 'button_blue.png'
		image-pressed: 'button_blue-pressed.png'
		image-disabled: 'button_blue.png'
	
		text-idle-padding-bottom: 13
		text-pressed-padding-top: 0
		text-disabled-padding-bottom: 13
	}

	Button
	{
		id: 'ReceiptUpArrow'
		observation-screen-name: 'Taskbar_ReceiptUpArrowButton'
		control-id: 'Taskbar'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 96
		height: 92
		padding-left: 520
	
		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'button_blueUp.png'
		image-pressed: 'button_blueUp-pressed.png'
		image-disabled: 'button_blueUp.png'
	}

	Button
	{
		id: 'ReceiptDownArrow'
		observation-screen-name: 'Taskbar_ReceiptDownArrowButton'
		control-id: 'Taskbar'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 96
		height: 92
		padding-left: 619
	
		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'button_blueDown.png'
		image-pressed: 'button_blueDown-pressed.png'
		image-disabled: 'button_blueDown.png'
	}

	Button
	{
		id: 'PayButton'
		observation-screen-name: 'Taskbar_PayButton'
		control-id: 'Taskbar'
	
		text: 'PAY'
		anchors: 'vertical-center|right'
		width: 225
		height: 92
		padding-right:  320

		visible: false

		font-name: 'Open Sans'
		font-size: 25
		font-weight: 'extrabold'

		disabled: false
		disabled-text-color: black
		pressed-text-color: white
		text-color: white
		image-idle: 'button_blue.png'
		image-pressed: 'button_blue-pressed.png'
		image-disabled: 'button_blue.png'

		text-idle-padding-bottom: 13
		text-pressed-padding-top: 0
		text-disabled-padding-bottom: 13
	}

	Button
	{
		id: 'StartOverButton'
		observation-screen-name: 'Taskbar_StartOverButton'
		control-id: 'Taskbar'
	
		text: 'START OVER'
		anchors: 'vertical-center|right'
		width: 225
		height: 92
		padding-right: 20

		font-name: 'Open Sans'
		font-size: 25
		font-weight: 'extrabold'

		visible: false

		disabled: false
		disabled-text-color: black
		pressed-text-color: white
		text-color: white
		image-idle: 'button_blue.png'
		image-pressed: 'button_blue-pressed.png'
		image-disabled: 'button_blue.png'
	
		text-idle-padding-bottom: 13
		text-pressed-padding-top: 0
		text-disabled-padding-bottom: 13
	}

	Item
	{
		id: 'OrderConfirmationTotals'

		anchors: 'fill'

		double-buffer: yes

		visible: false

		Text
		{
			id: 'SubtotalLabel'
			text: 'SUBTOTAL'

			font-name: 'Open Sans'
			font-weight: 'bold'
			font-size: 20

			height: 20
			width: 200

			color: '#9bc4e3'

			anchors: 'bottom|right'

			padding-bottom: 110
			padding-right: 200

			horizontal-alignment: far
		}

		Text
		{
			id: 'TaxLabel'
			text: 'TAX'

			font-name: 'Open Sans'
			font-weight: 'bold'
			font-size: 20

			height: 20
			width: 200

			color: '#9bc4e3'

			anchors: 'bottom|right'

			padding-bottom: 70
			padding-right: 200

			horizontal-alignment: far
		}

		Text
		{
			id: 'TotalLabel'
			text: 'TOTAL'

			font-name: 'Open Sans'
			font-weight: 'bold'
			font-size: 20

			height: 20
			width: 200

			color: '#9bc4e3'

			anchors: 'bottom|right'

			padding-bottom: 30
			padding-right: 200

			horizontal-alignment: far
		}

		Text
		{
			id: 'Subtotal'
			text: '$0.00'

			font-name: 'Open Sans'
			font-weight: 'bold'
			font-size: 23

			height: 23
			width: 170

			color: white

			anchors: 'bottom|right'

			padding-bottom: 110
			padding-right: -12

			horizontal-alignment: near
		}

		Text
		{
			id: 'Tax'
			text: '$0.00'

			font-name: 'Open Sans'
			font-weight: 'bold'
			font-size: 23

			height: 23
			width: 170

			color: white

			anchors: 'bottom|right'

			padding-bottom: 70
			padding-right: -12

			horizontal-alignment: near
		}

		Text
		{
			id: 'Total'
			text: '$0.00'

			font-name: 'Open Sans'
			font-weight: 'extrabold'
			font-size: 34

			height: 34
			width: 170

			color: white

			anchors: 'bottom|right'

			padding-bottom: 25
			padding-right: -10

			horizontal-alignment: near
		}
	}
}



