property banner-text base.top_banner.text.text
property banner-text-visible base.top_banner.text.visible
property main-text base.main_text.text
property main-text-visible base.main_text.visible
property left-card-visible base.card_left.visible
property left-card-image base.card_left.image.image-src
property center-card-visible base.card_center.visible
property center-card-image base.card_center.image.image-src
property right-card-visible base.card_right.visible
property right-card-image base.card_right.image.image-src
property mobile-code-visible base.mobile_code.visible
property mobile-code base.mobile_code.text.text
property new-content-visible base.card_right_new.visible
property new-ring-visible base.card_right_new.content.ring.visible
property new-content-offset-left base.card_right_new.content.padding-left
property new-content-offset-bottom base.card_right_new.content.padding-bottom

Layer
{
	id: 'base'
	anchors: 'fill'

	Image
	{
		id: 'background'
		anchors: 'fill'
		image-src: 'blue_background.png'
	}

	Layer
	{
		id: 'top_banner'
		height: 280
		width: 1100
		x: 410
		y: 820

		Text
		{
			id: 'text'
			height: 130
			width: 1100
			anchors: 'horizontal-center|bottom'
		}
	}

	Text
	{
		id: 'main_text'
		anchors: 'fill'
		vertical-alignment: 'center'
		horizontal-alignment: 'center'
	}

	Layer
	{
		id: 'card_left'
		width: 430
		height: 608
		x: 305
		y: 150

		ObservationMouseArea
		{
			id: 'mouse'
			observation-screen-name: 'PaymentMenuCardLeft'
			control-id: 'Payment'
			anchors: 'fill'
		}

		Image
		{
			id: 'image'
			anchors: 'fill'
			image-src: 'payment_menu_cash.png'
		}
	}

	Layer
	{
		id: 'card_center'
		width: 430
		height: 608
		x: 745
		y: 150

		ObservationMouseArea
		{
			id: 'mouse'
			observation-screen-name: 'PaymentMenuCardCenter'
			control-id: 'Payment'
			anchors: 'fill'
		}

		Image
		{
			id: 'image'
			anchors: 'fill'
			image-src: 'payment_menu_card.png'
		}
	}

	// Make sure the mobile code is first so it comes in behind the card
	Layer
	{
		id: 'mobile_code'
		width: 260
		height: 63
		x: 1270
		y: 162

		Image
		{
			id: 'background'
			anchors: 'fill'
			image-src: 'payment_menu_code_background.png'
		}

		Text
		{
			id: 'text'
			anchors: 'fill'
			text: ''
		}
	}

	Layer
	{
		id: 'card_right'
		width: 430
		height: 608
		x: 1185
		y: 150

		ObservationMouseArea
		{
			id: 'mouse'
			observation-screen-name: 'PaymentMenuCardRight'
			control-id: 'Payment'
			anchors: 'fill'
		}

		Image
		{
			id: 'image'
			anchors: 'fill'
			image-src: 'payment_menu_app.png'
		}
	}

	Layer
	{
		id: 'card_right_new'
		width: 200
		height: 200
		x: 1493
		y: 633

		// This item is just here for the padding. We want the 
		// main layer to be specified in xy coordinates, but the contents
		// of that layer must be shiftable by some offset to accomodate the
		// pressed state.
		Item
		{
			id: 'content'
			anchors: 'bottom|left'
			height: 200
			width: 200
			padding-left: 0
			padding-bottom: 0

			Layer
			{
				id: 'ring'
				anchors: 'fill'
				visible: false

				Image
				{
					id: 'image'
					anchors: 'fill'
					image-src: 'new_button_ring.png'
				}
			}

			// This needs to be a layer in order to ensure that it renders
			// on top of the ring. If it were just an item, then it would
			// work the other way around.
			Layer
			{
				id: 'button'
				anchors: 'fill'

				Image
				{
					id: 'image'
					anchors: 'fill'
					image-src: 'new_button.png'
				}
			}
		}
	}
}