Item
{
	id: 'Shadow'
	
	anchors: 'fill'
	
	Image
	{
		id: 'Top'
		
		anchors: 'left|right|top'
		padding-top: -8
		height: 8
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2100
		image-src-width: 837
		image-src-height: 8
	}
	
	Image
	{
		id: 'Bottom'
		
		anchors: 'left|right|bottom'
		padding-bottom: -16
		height: 16
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2605
		image-src-width: 837
		image-src-height: 16
	}
	
	// NOTE: Also includes top left and bottom left corners
	// Could be separated, if necessary
	Image
	{
		id: 'Left'
		
		anchors: 'left|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-left: -11
		width: 11
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 100
		image-src-top: 2100
		image-src-width: 11
		image-src-height: 518
	}
	
	// NOTE: Also includes top right and bottom right corners
	// Could be separated, if necessary
	Image
	{
		id: 'Right'
		
		anchors: 'right|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-right: -11
		width: 11
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 951
		image-src-top: 2100
		image-src-width: 11
		image-src-height: 519
	}
}

Item
{
	id: 'Dialog'
	
	anchors: 'fill'
	
	ObservationMouseArea
	{
		id: 'Mouse'
		observation-screen-name: 'RetailRegularPaymentDialog_DialogMouseArea'
		control-id: 'Carhop'

		anchors: 'fill'
	}
	
	Image
	{
		id: 'TitleBar'
		
		anchors: 'left|right|top'
		height: 128
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2108
		image-src-width: 837
		image-src-height: 109
		image-anchors: 'fill'
		enable-stretch-to-fit: false
		visible: true
		
		Button
		{
			id: 'Xbutton'
			observation-screen-name: 'RetailRegularPaymentDialog_CloseButton'
			control-id: 'Carhop'
			
			text: ''
			anchors: 'vertical-center|right'
			width: 85
			height: 85
			padding-right: 25
			padding-top: -5
			
			disabled: false
			disabled-text-color: black
			pressed-text-color: black
			text-color: black
			image-idle: '/Images/SpriteSheet-WholeProgram.png'
			image-pressed: '/Images/SpriteSheet-WholeProgram.png'
			image-disabled: '/Images/SpriteSheet-WholeProgram.png'
			image-idle-left: 400
			image-idle-width: 98
			image-idle-top: 900
			image-idle-height: 94
			image-pressed-left: 400
			image-pressed-width: 98
			image-pressed-top: 1000
			image-pressed-height: 94
			image-disabled-left: 400
			image-disabled-width: 98
			image-disabled-top: 900
			image-disabled-height: 94
		}
		
		
		Rectangle
		{
			id:'TitleTextArea'
			anchors: 'top|horizontal-center'
			width: 1208
			height: 135
			color: transparent
			visible: true
			
			Text
			{
				id: 'TitleText'
				anchors: 'fill'
				//anchors: 'top|horizontal-center'
				text: "Message received! We're making your food now."
				font-name: 'SONIC Sans Round'
				font-weight: 'bold'
				font-size: 32
				vertical-alignment: center
				horizontal-alignment: center
				color: white
				padding-top: -40
				visible: true
			}

			Text
			{
				id: 'SubTitleText'
				anchors: 'fill'
				//anchors: 'top|horizontal-center'
				text: 'Pay by card, with our app, or give cash to your carhop.'
				font-name: 'SONIC Sans Round Semi'
				font-weight: 'regular'
				font-size: 28
				vertical-alignment: center
				horizontal-alignment: center
				color: white
				padding-top: 55
				visible: true
			}
		}
	}

	Image
	{
		id: 'Content'
		
		anchors: 'left|right|bottom'
		height: 391
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2218
		image-src-width: 837
		image-src-height: 385
		image-anchors: 'fill'
		enable-stretch-to-fit: true
		
		Rectangle
		{
			id: 'TableArea'

			anchors: 'top|left'
			rounded-corners: 'left-bottom'
			x-radius: 5
			y-radius: 5
			width: 705
			height: 391
			color: transparent
			visible: true

			PaymentTable1By2
			{
				id: 'PaymentTable1By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			PaymentTable2By2
			{
				id: 'PaymentTable2By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			PaymentTable3By2
			{
				id: 'PaymentTable3By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			Image
			{
				id: 'CardImages'

				anchors: 'bottom|horizontal-center'
				padding-bottom: 40
				image-src: '/Images/cards.png'
				image-src-left: 0
				image-src-top: 0
				image-src-width: 344
				image-src-height: 40
				image-anchors: 'fill'
				enable-stretch-to-fit: false
				width: 344
				height: 40
			}
		}

		Rectangle
		{
			id: 'SideMessageArea'

			anchors: 'top|right'
			rounded-corners: 'right-bottom'
			x-radius: 5
			y-radius: 5
			width: 482
			height: 391
			color: '#f1f9ff'
			visible: true

			Rectangle
			{
				id: 'DividerLine'

				anchors: 'top|left|bottom'
				width: 2
				color: '#C7DAE6'
				visible: true
			}

			Rectangle
			{
				id: 'TextInformationArea'

				anchors: 'fill'
				color: inherit
				visible: true

				Text
				{
					id: 'Text'
					anchors: 'fill'
					text: "We'll race your order out shortly."
					font-name: 'SONIC Sans Round Semi'
					font-size: 30
					padding-left: 40
					padding-right: 40
					vertical-alignment: center
					horizontal-alignment: center
					color: black
					visible: true
				}
			}
		}
	}
}
