Item
{
	id: 'Shadow'
	
	anchors: 'fill'
	
	Image
	{
		id: 'Top'
		
		anchors: 'left|right|top'
		padding-top: -8
		height: 8
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2100
		image-src-width: 837
		image-src-height: 8
	}
	
	Image
	{
		id: 'Bottom'
		
		anchors: 'left|right|bottom'
		padding-bottom: -16
		height: 16
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2603
		image-src-width: 837
		image-src-height: 16
	}
	
	// NOTE: Also includes top left and bottom left corners
	// Could be separated, if necessary
	Image
	{
		id: 'Left'
		
		anchors: 'left|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-left: -11
		width: 11
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 100
		image-src-top: 2100
		image-src-width: 11
		image-src-height: 518
	}
	
	// NOTE: Also includes top right and bottom right corners
	// Could be separated, if necessary
	Image
	{
		id: 'Right'
		
		anchors: 'right|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-right: -11
		width: 11
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 950
		image-src-top: 2100
		image-src-width: 11
		image-src-height: 518
	}
}

Item
{
	id: 'Dialog'
	
	anchors: 'fill'
	
	ObservationMouseArea
	{
		id: 'Mouse'
		observation-screen-name: 'CarhopPaymentPrompt_DialogMouseArea'
		control-id: 'Carhop'

		anchors: 'fill'
	}
	
	Image
	{
		id: 'TitleBar'
		
		anchors: 'left|right|top'
		height: 128
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2108
		image-src-width: 837
		image-src-height: 109
		image-anchors: 'fill'
		enable-stretch-to-fit: false
		visible: true		
		
		Rectangle
		{
			id:'TitleTextArea'
			anchors: 'top|horizontal-center'
			width: 1208
			height: 135
			color: transparent
			visible: true
			
			Text
			{
				id: 'TitleText'
				anchors: 'fill'
				//anchors: 'top|horizontal-center'
				text: "Message received! We're making your food now."
				font-name: 'SONIC Sans Round'
				font-weight: 'bold'
				font-size: 32
				vertical-alignment: center
				horizontal-alignment: center
				color: white
				padding-top: -40
				visible: true
			}

			Text
			{
				id: 'SubTitleText'
				anchors: 'fill'
				//anchors: 'top|horizontal-center'
				text: 'Pay by card, with our app, or give cash to your carhop.'
				font-name: 'SONIC Sans Round'
				font-weight: 'regular'
				font-size: 28
				vertical-alignment: center
				horizontal-alignment: center
				color: white
				padding-top: 55
				visible: true
			}
		}
	}

	Image
	{
		id: 'Content'
		
		anchors: 'left|right|bottom'
		height: 391
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2218
		image-src-width: 837
		image-src-height: 385
		image-anchors: 'fill'
		enable-stretch-to-fit: true
		
		Rectangle
		{
			id: 'TableArea'

			anchors: 'top|left'
			rounded-corners: 'left-bottom'
			x-radius: 5
			y-radius: 5
			width: 705
			height: 391
			color: transparent
			visible: true

			PaymentTable1By2
			{
				id: 'PaymentTable1By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			PaymentTable2By2
			{
				id: 'PaymentTable2By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			PaymentTable3By2
			{
				id: 'PaymentTable3By2'

				anchors: 'top|horizontal-center'
				padding-top: 45
				width: 552
				height: 225
				visible: false
			}

			Image
			{
				id: 'CardImages'

				anchors: 'bottom|horizontal-center'
				padding-bottom: 40
				image-src: '/Images/cards.png'
				image-src-left: 0
				image-src-top: 0
				image-src-width: 344
				image-src-height: 40
				image-anchors: 'fill'
				enable-stretch-to-fit: false
				width: 344
				height: 40
			}
		}

		Rectangle
		{
			id: 'SideMessageArea'

			anchors: 'top|right'
			rounded-corners: 'right-bottom'
			x-radius: 5
			y-radius: 5
			width: 482
			height: 391
			color: '#f1f9ff'
			visible: true

			Rectangle
			{
				id: 'DividerLine'

				anchors: 'top|left|bottom'
				width: 2
				color: '#C7DAE6'
				visible: true
			}

			Rectangle
			{
				id: 'TextInformationArea'

				anchors: 'fill'
				color: inherit
				visible: true

				Text
				{
					id: 'Text'
					anchors: 'fill'
					text: "We'll race your order out shortly."
					font-name: 'SONIC Sans Round'
					font-size: 30
					padding-left: 70
					padding-right: 20
					vertical-alignment: center
					horizontal-alignment: center
					color: black
					visible: true
				}
			}
			
			Image
			{
				id: 'SonicLogo'
				
				anchors: 'horizontal-center|vertical-center'
				width: 350
				height: 157
				visible: false
				
				image-src: '/Images/SpriteSheet-CarhopAssist.png'
				image-src-left: 1450
				image-src-top: 1500
				image-src-width: 400
				image-src-height: 180
			}
		}
	}
}
