property title-text TitleBar.Title.Text.text
property title-width TitleBar.Title.width
property has-close-button CloseButton.visible

ObservationMouseArea
{
	id: 'Mouse'
	observation-screen-name: 'Dialog_BackgroundMouseArea'

	anchors: 'fill'
}

Item
{
	id: 'Shadow'
	
	anchors: 'fill'
	
	Image
	{
		id: 'Top'
		
		anchors: 'left|right|top'
		padding-top: -8
		height: 8
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2101
		image-src-width: 837
		image-src-height: 8
	}
	
	Image
	{
		id: 'Bottom'
		
		anchors: 'left|right|bottom'
		padding-bottom: -16
		height: 16
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 112
		image-src-top: 2604
		image-src-width: 837
		image-src-height: 16
	}
	
	// NOTE: Also includes top left and bottom left corners
	// Could be separated, if necessary
	Image
	{
		id: 'Left'
		
		anchors: 'left|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-left: -12
		width: 12
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 100
		image-src-top: 2101
		image-src-width: 12
		image-src-height: 518
	}
	
	// NOTE: Also includes top right and bottom right corners
	// Could be separated, if necessary
	Image
	{
		id: 'Right'
		
		anchors: 'right|top|bottom'
		padding-top: -8
		padding-bottom: -16
		padding-right: -12
		width: 12
		
		image-src: '/Images/SpriteSheet-WholeProgram.png'
		image-src-left: 950
		image-src-top: 2101
		image-src-width: 12
		image-src-height: 518
	}
}

Image
{
	id: 'ContentBackground'
	
	anchors: 'fill'
	padding-top: 108
	image-src: '/Images/SpriteSheet-WholeProgram.png'
	image-src-left: 112
	image-src-top: 2218
	image-src-width: 837
	image-src-height: 385
	image-anchors: 'fill'
	enable-stretch-to-fit: true
}

Image
{
	id: 'TitleBar'
	
	anchors: 'left|right|top'
	height: 108
	image-src: '/Images/SpriteSheet-WholeProgram.png'
	image-src-left: 112
	image-src-top: 2109
	image-src-width: 837
	image-src-height: 108
	image-anchors: 'fill'
	enable-stretch-to-fit: false
	visible: true
	
	Rectangle
	{
		id: 'Title'
		
		anchors: 'horizontal-center|vertical-center'
		// NOTE: Use title-width property instead
		// width: 0
		height: 100
		color: transparent
		visible: true

		Text
		{
			id: 'Text'
			
			anchors: 'fill'
			//anchors: 'top|horizontal-center'
			text: "CAP Dialog"
			font-name: 'Open Sans'
			font-weight: 'extrabold'
			font-size: 34
			vertical-alignment: center
			horizontal-alignment: center
			color: white
		}
	}
}

Button
{
	id: 'CloseButton'
	observation-screen-name: 'Dialog_CloseButton'
	control-id: 'Dialog'
	
	anchors: 'top|right'
	text: ''
	width: 85
	height: 85
	padding-top: 12
	padding-right: 12

	image-border-left: 5
	image-border-right: 5
	image-border-top: 10
	image-border-bottom: 10


	image-idle: '/Images/SpriteSheet-WholeProgram.png'
	image-pressed: '/Images/SpriteSheet-WholeProgram.png'
	image-disabled: '/Images/SpriteSheet-WholeProgram.png'
	image-idle-left: 400
	image-idle-width: 98
	image-idle-top: 900
	image-idle-height: 94
	image-pressed-left: 400
	image-pressed-width: 98
	image-pressed-top: 1000
	image-pressed-height: 94
	image-disabled-left: 400
	image-disabled-width: 98
	image-disabled-top: 900
	image-disabled-height: 94
}
