// Property settings
property message-text Base.Message.text
property button-text Base.ButtonBackground.StillHereText.text
property button-padding-bottom Base.ButtonBackground.padding-bottom


// Base layer for message and button
Layer
{
	id: 'Base'
	anchors: 'bottom|left|right'
	visible: true
    height: 155

    // Message background
	Rectangle
	{
		id: 'background'
		anchors: 'top|right|bottom'
		visible: true
		color: 'black'
        width: 1520
	}
    
    // Message text
    Text
    {
        id: 'Message'
        anchors: 'fill'
        visible: true
        color: 'white'

        padding-right: 25
        horizontal-alignment: center
        vertical-alignment: center

		text: 'Are you still there?'

		font-name: 'SONIC Sans Round Semi'
		font-size: 60
		font-weight: 'medium'
    }

    Rectangle
    {
        id: 'ButtonBackground'

        anchors: 'right|vertical-center'
        visible: true

        padding-right: 25
        padding-bottom: 0
        width: 350
        height: 100

        color: 'white'
        rounded-corners: all
		x-radius: 20
		y-radius: 20
        
        // "I'm still here" button
        ObservationMouseArea
        {
            id: 'StillHereButton'
            anchors: 'fill'
            observation-screen-name: 'StillHere_Confirm'
            control-id: 'StillHere'
        }

        Text
        {
            id: 'StillHereText'
            anchors: 'fill'

            visible: true
            color: 'black'

            font-name: 'SONIC Sans Round'
		    font-size: 40
		    font-weight: 'bold'
            text-color: 'white'
            text: 'Still here!'
        }
    }
}
