
//main area
property main-area-text base.mainArea_item.messageText.text
property main-area-bg-visible base.mainArea.visible
property main-area-bg-pressed-visible base.mainArea_pressed.visible

//stall id area
property stall-id-area-bg-visible base.stallIdArea_bg.visible
property stall-id-area-bg-pressed-visible base.stallIdArea_bg_pressed.visible
property stall-id-area-text base.stallIdArea.stallIdText.text
property stall-id-area-text-visible base.stallIdArea.stallIdText.visible
property stall-id-area-image-visible base.stallIdArea.MobilePairedImage.visible

//top accent line
property accent-line-bg-visible base.topAccentLine.visible
property accent-line-bg-pressed-visible base.topAccentLine_pressed.visible

//order tray
property totals-visible base.OrderConfirmationTotals.visible
property totals-tax base.OrderConfirmationTotals.Tax.text
property totals-total base.OrderConfirmationTotals.Total.text
property spanish-visible base.SpanishButton.visible
property spanish-text base.SpanishButton.text
property scrollup-visible base.ReceiptUpArrow.visible
property scrolldown-visible base.ReceiptDownArrow.visible
property scrollup-disabled base.ReceiptUpArrow.disabled
property scrolldown-disabled base.ReceiptDownArrow.disabled

Item
{
	id: 'base'
	anchors: 'fill'
	
	Rectangle
	{
		id: 'topAccentLine'
		anchors: 'left|top|right'
		height: 5
		color: '#EED713'
	}
	
	Rectangle
	{
		id: 'topAccentLine_pressed'
		anchors: 'left|top|right'
		height: 5
		color: '#7E1D17'
	}
	
	Rectangle
	{
		id: 'mainArea'
		anchors: 'fill'
		padding-top: 5
		color: '#2A2F32'
	}
	
	Rectangle
	{
		id: 'mainArea_pressed'
		anchors: 'fill'
		padding-top: 5
		padding-right: 166
		color: '#EB3124'
	}
	Item 
	{
		id: 'mainArea_item'
		anchors: 'fill'
		padding-top: 5
		padding-right: 166
		
		Text
		{
			id: 'messageText'
			anchors: 'fill'
			padding-left: 170
			padding-right: 4

			font-name: 'Akko Rounded Std'
			font-weight: 'regular'
			font-size: 20
			color: 'black'

			horizontal-alignment: center
			vertical-alignment: center
			
			text: ''
		}
	}
	
	Rectangle
	{
		id: 'stallIdArea_bg'
		anchors: 'top|right|bottom'
		padding-top: 5
		width: 166
		color: '#42494C'
	}
	
	Rectangle
	{
		id: 'stallIdArea_bg_pressed'
		anchors: 'top|right|bottom'
		padding-top: 5
		width: 166
		color: '#BA160B'
	}
	
	Item
	{
		id: 'stallIdArea'
		anchors: 'top|right|bottom'
		padding-top: 5
		width: 166
		
		Text
		{
			id: 'stallIdText'
			anchors: 'fill'
			padding-top: 15

			font-name: 'Sonic License Plate'
			font-weight: 'regular'
			font-size: 30
			color: 'white'

			horizontal-alignment: 'center'
			vertical-alignment: 'near'
			
			text: ''
		}

		Image
		{
			id: 'MobilePairedImage'
			anchors: 'fill'
			padding-top: 15
			image-src: 'Images/MobilePairedTray.png'
			width: 129
			height: 119
			visible: false
		}
	}
	
	Button
	{
		id: 'SpanishButton'
		observation-screen-name: 'Tray_LanguageButton'
		control-id: 'Tray'
	
		text: 'ESPANOL' // This needs to be a UTF8 string, but our parser won't allow it, so no tilde
		anchors: 'vertical-center|left'
		width: 180
		height: 80
		padding-left: 55
		padding-bottom: 5

		font-name: 'Akko Rounded Std'
		font-size: 32
		font-weight: 'regular'

		visible: false

		disabled: false
		disabled-text-color: black
		pressed-text-color: '#D8DEE4'
		text-color: '#D8DEE4'
		image-idle: 'language_button.png'
		image-pressed: 'language_button_pressed.png'
		image-disabled: 'language_button.png'
	
		text-idle-padding-bottom: 5
		text-pressed-padding-top: 0
		text-disabled-padding-bottom: 13
	}

	Button
	{
		id: 'ReceiptUpArrow'
		observation-screen-name: 'Tray_ReceiptUpArrowButton'
		control-id: 'Tray'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 280
		height: 113
		padding-left: 650
		padding-bottom: 10
		padding-right: 10
	
		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'oc_arrow_up_idle.png'
		image-pressed: 'oc_arrow_up_pressed.png'
		image-disabled: 'oc_arrow_up_pressed.png'
	}

	Button
	{
		id: 'ReceiptDownArrow'
		observation-screen-name: 'Tray_ReceiptDownArrowButton'
		control-id: 'Tray'
	
		text: ''
		anchors: 'vertical-center|left'
		width: 280
		height: 113
		padding-left: 940
		padding-bottom: 10
		padding-right: 10
	
		visible: false

		disabled: false
		disabled-text-color: white
		pressed-text-color: black
		text-color: black
		image-idle: 'oc_arrow_down_idle.png'
		image-pressed: 'oc_arrow_down_pressed.png'
		image-disabled: 'oc_arrow_down_pressed.png'
	}

	Item
	{
		id: 'OrderConfirmationTotals'

		anchors: 'fill'

		double-buffer: yes

		visible: false

		Text
		{
			id: 'Tax'
			text: 'TAX $0.00'

			font-name: 'Akko Rounded Std'
			font-weight: 'bold'
			font-size: 28

			height: 30
			width: 400

			color: white

			anchors: 'bottom|right'

			padding-bottom: 95
			padding-right: 50

			horizontal-alignment: far
		}

		Text
		{
			id: 'Total'
			text: 'TOTAL $0.00'

			font-name: 'Akko Rounded Std'
			font-weight: 'extrabold'
			font-size: 72

			height: 82
			width: 400 

			color: white

			anchors: 'bottom|right'

			padding-bottom: 15
			padding-right: 50

			horizontal-alignment: far
		}
	}

}