/*
Quick Launch extension for Windows 96.

Copyright (C) Windows 96 Team 2021.
*/

// Apply some styles
const stEl = document.createElement('style');
stEl.innerText = `
.quick-launch {
    border-right: 1px solid gray;
    border-left: 1px solid gray;
    padding-left: 3px;
    padding-right: 5px;
    margin-right: 5px;
    margin-left: 5px;
    height: calc(100% - 2px);
}

.quick-launch>.item {
    height: 100%;
    width: 25px;
    background-image: url(/system/resource/themes/default/icons/small/folder.png);
    background-position: center;
    background-repeat: no-repeat;
    background-position-y: 3px;
    display: inline-block;
	border: 1px solid transparent;
}

.quick-launch>.item:hover {
    border: inset 1px;
}
`;
document.body.appendChild(stEl);

w96.evt.sys.on('init-complete', async()=>{
    const taskbar = document.querySelector('.user-taskbar');
	const qlBar = document.createElement("div");
	qlBar.classList.add("quick-launch");
	
	if(!await w96.FS.exists("c:/system/etc/quick-launch"))
		await w96.FS.mkdir("c:/system/etc/quick-launch");
	
	(await w96.FS.readdir("c:/system/etc/quick-launch")).forEach(async(item)=>{
		const qlItem = document.createElement('div');
		qlItem.classList.add('item');
		let url = await w96.ui.Theme.getFileIconUrl(item, '16x16');
		
		if(item.endsWith(".link")) {
			try {
				const shortcut = await w96.FS.readstr(item);
				const reconObj = JSON.parse(shortcut);
				
				if((reconObj != null) && (reconObj.icon != null))
					url = await w96.ui.Theme.getIconUrl(reconObj.icon, "16x16");
			} catch(e) {
				console.error(`Failed reading shortcut ${item}: ${e}`);
			}
		}
		
		qlItem.style.backgroundImage = `url(${url})`;
		qlItem.addEventListener('click', ()=>{
			w96.sys.execFile(item);
		});
		qlBar.appendChild(qlItem);
	});
	
    taskbar.insertBefore(qlBar, document.querySelector(".start_button"));
});